function klot(r0,rp,c)
% KLOT plots a sphere on the current figure
% 
% KLOT(r0,rp,c) draws a sphere of colour c with its centre at r0 and north
%               pole at r0+rp
%               If c is a one character string the whole sphere will have
%               the colour described by that character. If c contains two
%               characters the sphere will be constructed of two hemispheres
%               of colours c(1) and c(2).

% HG 2004-06-10

h=ishold;

% Defaults if no or few arguments are given.
if nargin<3
  c='rw';
  if nargin<2
    rp=[0 0 1];
    if nargin<1
      r0=[0 0 0];
    end
  end
end

% A is the transformation matrix that turns the sphere depending on rp.
if rp(1)==0 & rp(2)==0
  A=[1 0 0;0 1 0;0 0 1]*rp(3);
else
  rr=sqrt(sum(rp.^2));
  A=[cross(cross([0;0;1],rp(:)),rp(:)) cross([0;0;1],rp(:)) rp(:)];
  A=rr*A./([1;1;1]*sqrt(sum(A.^2)));
end

% One-coloured or two-coloured sphere
if length(c)<2
  c(2)=c(1);
end

% First hemisphere, i.e., nightside.
fi=[97.5:15:262.5]*pi/180;dfi=fi(2)-fi(1);
theta=[5:10:175]*pi/180;dtheta=theta(2)-theta(1);

rx=zeros(length(theta)*length(fi),4);ry=rx;rz=rx;
for jj=1:length(theta)
  for ii=1:length(fi)
    x=sin(theta(jj)+[-1 -1 1 1]*dtheta*0.5).*cos(fi(ii)+[-1 1 1 -1]*dfi*0.5);
    y=sin(theta(jj)+[-1 -1 1 1]*dtheta*0.5).*sin(fi(ii)+[-1 1 1 -1]*dfi*0.5);
    z=cos(theta(jj)+[-1 -1 1 1]*dtheta*0.5);
    r=A*[x;y;z];
    rx((jj-1)*length(fi)+ii,:)=r0(1)+r(1,:);
    ry((jj-1)*length(fi)+ii,:)=r0(2)+r(2,:);
    rz((jj-1)*length(fi)+ii,:)=r0(3)+r(3,:);
  end
end

fill3(rx',ry',rz',c(1))
hold on

% Last hemisphere, i.e., dayside.
fi=[-82.5:15:82.5]*pi/180;dfi=fi(2)-fi(1);
theta=[5:10:175]*pi/180;dtheta=theta(2)-theta(1);

rx=zeros(length(theta)*length(fi),4);ry=rx;rz=rx;
for jj=1:length(theta)
  for ii=1:length(fi)
    x=sin(theta(jj)+[-1 -1 1 1]*dtheta*0.5).*cos(fi(ii)+[-1 1 1 -1]*dfi*0.5);
    y=sin(theta(jj)+[-1 -1 1 1]*dtheta*0.5).*sin(fi(ii)+[-1 1 1 -1]*dfi*0.5);
    z=cos(theta(jj)+[-1 -1 1 1]*dtheta*0.5);
    r=A*[x;y;z];
    rx((jj-1)*length(fi)+ii,:)=r0(1)+r(1,:);
    ry((jj-1)*length(fi)+ii,:)=r0(2)+r(2,:);
    rz((jj-1)*length(fi)+ii,:)=r0(3)+r(3,:);
  end
end

fill3(rx',ry',rz',c(2))


% Return hold state to what it was before. 
if h==0
  hold off
else
  hold on
end
